/****************************************************************************************/
/**
  Copyright (c) 2008 Freescale Semiconductor
  Freescale Confidential Proprietary
  \file       AdcFltr_Cfg.c
  \brief      ADC Filter configuration file
  \author     Freescale Semiconductor
  \author     R01160
  \author     Guadalajara Applications Laboratory RTAC Americas
  \version    1.0
  \date       12/08/2008 11:43:36 AM

  * History:
  
*/
/****************************************************************************************/
/** Filter Configuration parameters */
#include "AdcFltr_Cfg.h"



uint16_t atdfltr_0_channel[ATDFLTR_0_AVERAGECHANNELS][ATDFLTR_0_AVERAGETAPS + 1]; /* Circular buffer         */
uint16_t atdfltr_0_FilterResults[ATDFLTR_0_AVERAGECHANNELS];                      /* array of all results    */
tAdcFltr_ChannelStruct AdcFltr_0_ChannelStruct[ATDFLTR_0_AVERAGECHANNELS];        /* array of Filter channels*/

#if (ADCFLTR_TC006 == ON)
  uint16_t u16AdcChannel_Convert[ATDFLTR_0_AVERAGECHANNELS] = 
{
	ADC_CHANNEL_0,  /* Adc Channel 0 */
	ADC_CHANNEL_1  /* Adc Channel 1 */
};
#endif

#if ((ADCFLTR_TC006 != ON) && (ADCFLTR_TC007 != ON))
uint16_t u16AdcChannel_Convert[ATDFLTR_0_AVERAGECHANNELS] = 
{
	ADC_CHANNEL_0,  /* Adc Channel 0 */
	ADC_CHANNEL_1,  /* Adc Channel 1 */
	ADC_CHANNEL_2,  /* Adc Channel 2 */
	ADC_CHANNEL_3   /* Adc Channel 3 */
};
#endif

#if(ADCFLTR_TC007 == ON)
uint16_t u16AdcChannel_Convert[ATDFLTR_0_AVERAGECHANNELS] = 
{
	ADC_CHANNEL_0,  /* Adc Channel 0 */
	ADC_CHANNEL_1,  /* Adc Channel 1 */
	ADC_CHANNEL_2,  /* Adc Channel 2 */
	ADC_CHANNEL_3,  /* Adc Channel 3 */
    ADC_CHANNEL_4,  /* Adc Channel 4 */
	ADC_CHANNEL_5   /* Adc Channel 5 */
};
#endif

/* Filter struct     */
tAdcFltr_FilterStruct sATD0 = 
{
  AdcFltr_0_ChannelStruct,       /* Adc Channel Control Variables                      */
  {
    ATDFLTR_0_AVERAGETAPS,       /* Adc Channel Control Variables                      */
    ATDFLTR_0_AVERAGECHANNELS,   /* Number of samples to be acquired                   */
    ATDFLTR_0_AVERAGEINTERRUPT,  /* Indicates if Filter End fnc shall be invoked or not*/
    ATDFLTR_0_FILTER_FNC         /* Filter End function name. Filter driver jumps into this function */
  }
};   
    


       